;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeCreate[START]OfMsiFromScratch.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.4  $
;          $Date:   21 Dec 2006 17:54:02  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeCreate[START]OfMsiFromScratch.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; This is a simple sample/test MSI.
;
; This shows how an MSI could be created from scratch.
; It doesn't attempt to create a working MSI, just to demonstrate the basics.
; If you try to install the generated MSI you will get an error message
; about an invalid package, use "ORCA.EXE" or similar table editor to examine
; it (there will only be the single row in the single table ("Binary table).
;
; As the MSI is not complete you could expect it to fail validation, this is
; why this sample disables validation.
;----------------------------------------------------------------------------


;--- Disable Validation (we know it will fail badly) ------------------------
#define  VALID_ValidateTheGeneratedMsi          ;;remember only generating partial MSI!


;--- We will do everything ourselves ----------------------------------------
#define  DBG_ALL                     Y          ;;Good unless you think it impacts performance
#include "OpenMsi.mmh"


;--- Where do we wish the MSI generated? ------------------------------------
#define MSI_DIR <$MAKEMSI_OUT_MSI_DIR>          ;;Ends with '\'
#DefineRexx ''
    ;--- Make sure it exists ------------------------------------------------
    call MakeDirectoryTree "<$MSI_DIR>"
#DefineRexx


;--- Create a new MSI and don't start with a template -----------------------
<$Msi "<$MSI_DIR>WillNotInstall-UseOrcaToExamine.MSI" CREATE="Y">
    ;--- Add Binary to the file ---------------------------------------------
    <$Binary "c:\program files\makemsi\MakeMSI.DLL">
<$/Msi>